<?php
  // XCache API: http://xcache.lighttpd.net/wiki/XcacheApi

  // always put index hooks in front since standard hook is the last one.
  BEvent::HookFirst('index: file load', array('XCacheIndex', 'Load'));
  BEvent::HookFirst('index: file save', array('XCacheIndex', 'Save'));

  BaseFileIndex::$noBuffering = true;

  if (!function_exists('xcache_get')) {
    throw new BException('For this plugin to work your server needs XCache PHP module installed.');
  }

/* one-shot */
  $this->name = 'xcache index';
  $this->Caption('Быстрые индексы (XCache)', 'ru');
/* isntall XCacheIndex */
class XCacheIndex {
  // 0 - flush on every request; 1 - never flush; 2+ - flush cache to disk each N
  // write requests (cross-page, not during script's session).
  static $flushInterval = 20;

  static function Load($index, &$data) {
    $data = xcache_get( self::NameOf($index) );

      if ($data === null) {
        BaseFileIndex::LoadFrom($index, $data);
        self::Save($index, $data);
      }

    return $data;
  }

    static function NameOf($var, $what = 'index') {
      return BConfig::$siteName."\nxcache $what\n$var";
    }

  static function Save($index, &$data) {
    if (!xcache_set(self::NameOf($index), $data)) {
      throw new BException("Cannot store index $index in XCache.");
    }

    $flushCtr = self::NameOf($index, 'flush counter');
    // the result of null makes the chain continue eventually reaching the standard flusher.
    switch (self::$flushInterval) {
    case 0:   return null;
    case 1:   return true;
    default:  return xcache_inc($flushCtr) % self::$flushInterval === 0 ? null : true;
    }
  }
}
